package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.PulseOximetryConverter;
import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.model.PulseOximetryReading;
import gov.va.med.mhv.vitals.repository.PulseOximetryReadingRepository;
import gov.va.med.mhv.vitals.service.PulseOximetryService;
import gov.va.med.mhv.vitals.validator.PulseOximetryValidaor;

@Component
public class PulseOximetryServiceImpl  implements PulseOximetryService{
	
	
	private static Logger log = LogManager.getLogger(PulseOximetryServiceImpl.class);
	
	@Autowired
	private PulseOximetryReadingRepository poRepository;
	
	@Autowired
	private PulseOximetryValidaor validator;


	@Override
	public ResponseUtil<Long> save(PulseOximetryReadingDTO pulseOximetryDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.pulseOXimetryValidations(response, pulseOximetryDTO);
		if(response.getValidationErrors().size() == 0){
			PulseOximetryReading poReading = PulseOximetryConverter.convertPulseOXimetryReadingDTO(pulseOximetryDTO);
			poReading = poRepository.save(poReading);
			response.setSuccess(true);
			response.setPojoObject(poReading.getId());
		}else{
			log.debug("Validation Errors in save Pulsse Oximetry reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		poRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		PulseOximetryReading poReading = poRepository.findOne(id);
		if(poReading != null){
			PulseOximetryReadingDTO pulseOximetryDTO = PulseOximetryConverter.convertPulseOximetryReadingDomain(poReading);
			response.setPojoObject(pulseOximetryDTO);
			response.setSuccess(true);
		}else{
			log.debug("Pulsse Oximetry Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<PulseOximetryReadingDTO>> getPulseOximetryReadingsForUser(Long userprofileid) {
		ResponseUtil<List<PulseOximetryReadingDTO>> response = new ResponseUtil<List<PulseOximetryReadingDTO>>();
		List<PulseOximetryReading> poReadings=poRepository.getPulseOximetryReadingsForUser(userprofileid);
		if(poReadings != null){
			List<PulseOximetryReadingDTO> dtos = PulseOximetryConverter.convertPulseOximetryReadings(poReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Pulsse Oximetry Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<PulseOximetryReadingDTO>> getPulseOximetryDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<PulseOximetryReadingDTO>> response = new ResponseUtil<List<PulseOximetryReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<PulseOximetryReading> poReadings=poRepository.getDashBoardPulseOximetryReadingsForUser(userprofileid, topFive);
		if(poReadings != null){
			List<PulseOximetryReadingDTO> dtos = PulseOximetryConverter.convertPulseOximetryReadings(poReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Pulsse Oximetry Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<PulseOximetryReadingDTO> getPulseOximetryReadingByid(Long userProfileId, Long id) {
		ResponseUtil<PulseOximetryReadingDTO> response = new ResponseUtil<PulseOximetryReadingDTO>();
		PulseOximetryReading poReading = poRepository.findOne(id);
		if(poReading != null){
			PulseOximetryReadingDTO dto=PulseOximetryConverter.convertPulseOximetryReadingDomain(poReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Pulse Oximetry Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}

}
